

# Peptidoform level analysis #


source('D:/Pipeline comparisons/Writing/R Functions/PD Binomial Scores Function Peptidoform level PD.R')
source('D:/Pipeline comparisons/Writing/R Functions/PD FLR function Bin Adjusted PD.R')
source('D:/Pipeline comparisons/Writing/R Functions/Function frequency of site PDiscoverer.R')



# We want to assess if there are any differences between the Max and MM collapsing methods using all rice data sets #

#> [conflicted] Will prefer dplyr::filter over any other package
suppressPackageStartupMessages(library("tidyverse"))

library(dplyr)
library(stringr)
library(useful)
library(MASS)
library(reshape2)
library(epiDisplay)

# First we calculate all binomial adjusted data #
#################################################

PXD000923A <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD000923A_PSMSITE.csv')
PXD002222A <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD002222A_PSMSITE.csv')
PXD002756A <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD002756A_PSMSITE.csv')
PXD004705A <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD004705A_PSMSITE.csv')
PXD004939A <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD004939A_PSMSITE.csv')
PXD005241A <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD005241A_PSMSITE.csv')
PXD012764A <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD012764A_PSMSITE.csv')
PXD019291A <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD019291A_PSMSITE.csv')

PXD000923 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD000923_PSMSITE.csv')
PXD002222 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD002222_PSMSITE.csv')
PXD002756 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD002756_PSMSITE.csv')
PXD004705 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD004705_PSMSITE.csv')
PXD004939 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD004939_PSMSITE.csv')
PXD005241 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD005241_PSMSITE.csv')
PXD012764 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD012764_PSMSITE.csv')
PXD019291 <- read.csv(file = 'D:/Pipeline comparisons/Writing/Data/PD/Rice/PD_PXD019291_PSMSITE.csv')


PXD000923A$dataset <- "PXD000923"
PXD002222A$dataset <- "PXD002222"
PXD002756A$dataset <- "PXD002756"
PXD004705A$dataset <- "PXD004705"
PXD004939A$dataset <- "PXD004939"
PXD005241A$dataset <- "PXD005241"
PXD012764A$dataset <- "PXD012764"
PXD019291A$dataset <- "PXD019291"

PXD000923$dataset <- "PXD000923"
PXD002222$dataset <- "PXD002222"
PXD002756$dataset <- "PXD002756"
PXD004705$dataset <- "PXD004705"
PXD004939$dataset <- "PXD004939"
PXD005241$dataset <- "PXD005241"
PXD012764$dataset <- "PXD012764"
PXD019291$dataset <- "PXD019291"

PXD000923$PTM_Final_prob <- (PXD000923$ptmRS_Score/100)*(1-PXD000923$PEP)
PXD002222$PTM_Final_prob <- (PXD002222$ptmRS_Score/100)*(1-PXD002222$PEP)
PXD002756$PTM_Final_prob <- (PXD002756$ptmRS_Score/100)*(1-PXD002756$PEP)
PXD004705$PTM_Final_prob <- (PXD004705$ptmRS_Score/100)*(1-PXD004705$PEP)
PXD004939$PTM_Final_prob <- (PXD004939$ptmRS_Score/100)*(1-PXD004939$PEP)
PXD005241$PTM_Final_prob <- (PXD005241$ptmRS_Score/100)*(1-PXD005241$PEP)
PXD012764$PTM_Final_prob <- (PXD012764$ptmRS_Score/100)*(1-PXD012764$PEP)
PXD019291$PTM_Final_prob <- (PXD019291$ptmRS_Score/100)*(1-PXD019291$PEP)

PXD000923A$PTM_Final_prob <- (PXD000923A$ptmRS_Score/100)*(1-PXD000923A$PEP)
PXD002222A$PTM_Final_prob <- (PXD002222A$ptmRS_Score/100)*(1-PXD002222A$PEP)
PXD002756A$PTM_Final_prob <- (PXD002756A$ptmRS_Score/100)*(1-PXD002756A$PEP)
PXD004705A$PTM_Final_prob <- (PXD004705A$ptmRS_Score/100)*(1-PXD004705A$PEP)
PXD004939A$PTM_Final_prob <- (PXD004939A$ptmRS_Score/100)*(1-PXD004939A$PEP)
PXD005241A$PTM_Final_prob <- (PXD005241A$ptmRS_Score/100)*(1-PXD005241A$PEP)
PXD012764A$PTM_Final_prob <- (PXD012764A$ptmRS_Score/100)*(1-PXD012764A$PEP)
PXD019291A$PTM_Final_prob <- (PXD019291A$ptmRS_Score/100)*(1-PXD019291A$PEP)


# pSTY peptidoform level #
##########################

PXD000923$Peptide_mod <- paste0(PXD000923$Sequence,"_",gsub("\\s*\\([^\\)]+\\)","",as.character(gsub( ';', '_',PXD000923$Modifications))))
PXD002222$Peptide_mod <- paste0(PXD002222$Sequence,"_",gsub("\\s*\\([^\\)]+\\)","",as.character(gsub( ';', '_',PXD002222$Modifications))))
PXD002756$Peptide_mod <- paste0(PXD002756$Sequence,"_",gsub("\\s*\\([^\\)]+\\)","",as.character(gsub( ';', '_',PXD002756$Modifications))))
PXD004705$Peptide_mod <- paste0(PXD004705$Sequence,"_",gsub("\\s*\\([^\\)]+\\)","",as.character(gsub( ';', '_',PXD004705$Modifications))))
PXD004939$Peptide_mod <- paste0(PXD004939$Sequence,"_",gsub("\\s*\\([^\\)]+\\)","",as.character(gsub( ';', '_',PXD004939$Modifications))))
PXD005241$Peptide_mod <- paste0(PXD005241$Sequence,"_",gsub("\\s*\\([^\\)]+\\)","",as.character(gsub( ';', '_',PXD005241$Modifications))))
PXD012764$Peptide_mod <- paste0(PXD012764$Sequence,"_",gsub("\\s*\\([^\\)]+\\)","",as.character(gsub( ';', '_',PXD012764$Modifications))))
PXD019291$Peptide_mod <- paste0(PXD019291$Sequence,"_",gsub("\\s*\\([^\\)]+\\)","",as.character(gsub( ';', '_',PXD019291$Modifications))))

PXD000923$Peptidoform <- paste0(PXD000923$Peptide_mod,"_",PXD000923$PTM_Positions)
PXD002222$Peptidoform <- paste0(PXD002222$Peptide_mod,"_",PXD002222$PTM_Positions)
PXD002756$Peptidoform <- paste0(PXD002756$Peptide_mod,"_",PXD002756$PTM_Positions)
PXD004705$Peptidoform <- paste0(PXD004705$Peptide_mod,"_",PXD004705$PTM_Positions)
PXD004939$Peptidoform <- paste0(PXD004939$Peptide_mod,"_",PXD004939$PTM_Positions)
PXD005241$Peptidoform <- paste0(PXD005241$Peptide_mod,"_",PXD005241$PTM_Positions)
PXD012764$Peptidoform <- paste0(PXD012764$Peptide_mod,"_",PXD012764$PTM_Positions)
PXD019291$Peptidoform <- paste0(PXD019291$Peptide_mod,"_",PXD019291$PTM_Positions)


PXD000923$PROTEIN_LOC <- paste0(PXD000923$Protein,"_",PXD000923$PRO_Position)
PXD002222$PROTEIN_LOC <- paste0(PXD002222$Protein,"_",PXD002222$PRO_Position)
PXD002756$PROTEIN_LOC <- paste0(PXD002756$Protein,"_",PXD002756$PRO_Position)
PXD004705$PROTEIN_LOC <- paste0(PXD004705$Protein,"_",PXD004705$PRO_Position)
PXD004939$PROTEIN_LOC <- paste0(PXD004939$Protein,"_",PXD004939$PRO_Position)
PXD005241$PROTEIN_LOC <- paste0(PXD005241$Protein,"_",PXD005241$PRO_Position)
PXD012764$PROTEIN_LOC <- paste0(PXD012764$Protein,"_",PXD012764$PRO_Position)
PXD019291$PROTEIN_LOC <- paste0(PXD019291$Protein,"_",PXD019291$PRO_Position)

# Data collapsed by taking the Max by peptidoform #

PXD000923_pform <- aggregate(PTM_Final_prob ~ Peptidoform+dataset+Sequence+Peptide_mod+PTM_Positions+PROTEIN_LOC, data = PXD000923, max)
PXD002222_pform <- aggregate(PTM_Final_prob ~ Peptidoform+dataset+Sequence+Peptide_mod+PTM_Positions+PROTEIN_LOC, data = PXD002222, max)
PXD002756_pform <- aggregate(PTM_Final_prob ~ Peptidoform+dataset+Sequence+Peptide_mod+PTM_Positions+PROTEIN_LOC, data = PXD002756, max)
PXD004705_pform <- aggregate(PTM_Final_prob ~ Peptidoform+dataset+Sequence+Peptide_mod+PTM_Positions+PROTEIN_LOC, data = PXD004705, max)
PXD004939_pform <- aggregate(PTM_Final_prob ~ Peptidoform+dataset+Sequence+Peptide_mod+PTM_Positions+PROTEIN_LOC, data = PXD004939, max)
PXD005241_pform <- aggregate(PTM_Final_prob ~ Peptidoform+dataset+Sequence+Peptide_mod+PTM_Positions+PROTEIN_LOC, data = PXD005241, max)
PXD012764_pform <- aggregate(PTM_Final_prob ~ Peptidoform+dataset+Sequence+Peptide_mod+PTM_Positions+PROTEIN_LOC, data = PXD012764, max)
PXD019291_pform <- aggregate(PTM_Final_prob ~ Peptidoform+dataset+Sequence+Peptide_mod+PTM_Positions+PROTEIN_LOC, data = PXD019291, max)


# pASTY peptidoform level #
##########################


library(plyr)

PXD000923A_pform <- binAdjustPformPD(PXD000923A)
PXD002222A_pform <- binAdjustPformPD(PXD002222A)
PXD002756A_pform <- binAdjustPformPD(PXD002756A)
PXD004705A_pform <- binAdjustPformPD(PXD004705A)
PXD004939A_pform <- binAdjustPformPD(PXD004939A)
PXD005241A_pform <- binAdjustPformPD(PXD005241A)
PXD012764A_pform <- binAdjustPformPD(PXD012764A)
PXD019291A_pform <- binAdjustPformPD(PXD019291A)

detach(package:plyr)


PXD000923A_pform <- FLR_AdjPD(PXD000923A_pform)
PXD002222A_pform <- FLR_AdjPD(PXD002222A_pform)
PXD002756A_pform <- FLR_AdjPD(PXD002756A_pform)
PXD004705A_pform <- FLR_AdjPD(PXD004705A_pform)
PXD004939A_pform <- FLR_AdjPD(PXD004939A_pform)
PXD005241A_pform <- FLR_AdjPD(PXD005241A_pform)
PXD012764A_pform <- FLR_AdjPD(PXD012764A_pform)
PXD019291A_pform <- FLR_AdjPD(PXD019291A_pform)


write.csv(PXD000923_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD000923_pform.csv")
write.csv(PXD002222_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD002222_pform.csv")
write.csv(PXD002756_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD002756_pform.csv")
write.csv(PXD004705_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD004705_pform.csv")
write.csv(PXD004939_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD004939_pform.csv")
write.csv(PXD005241_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD005241_pform.csv")
write.csv(PXD012764_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD012764_pform.csv")
write.csv(PXD019291_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD019291_pform.csv")

write.csv(PXD000923A_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD000923A_pform.csv")
write.csv(PXD002222A_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD002222A_pform.csv")
write.csv(PXD002756A_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD002756A_pform.csv")
write.csv(PXD004705A_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD004705A_pform.csv")
write.csv(PXD004939A_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD004939A_pform.csv")
write.csv(PXD005241A_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD005241A_pform.csv")
write.csv(PXD012764A_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD012764A_pform.csv")
write.csv(PXD019291A_pform, "D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD019291A_pform.csv")

############################################################################################################################################
# COMPARISON
############################################################################################################################################




AllRice_pASTY_pform <-dplyr::bind_rows(PXD000923A_pform,PXD002222A_pform, PXD002756A_pform, PXD004705A_pform,PXD004939A_pform, 
                                       PXD005241A_pform,PXD012764A_pform,PXD019291A_pform)

AllRice_pASTY_pform_Excluding_A <- AllRice_pASTY_pform[AllRice_pASTY_pform$Amino!="A",]

tab1(AllRice_pASTY_pform_Excluding_A$dataset, graph = FALSE)

AllRice_pSTY_pform <-dplyr::bind_rows(PXD000923_pform,PXD002222_pform, PXD002756_pform, PXD004705_pform,PXD004939_pform, 
                                     PXD005241_pform,PXD012764_pform,PXD019291_pform)

tab1(AllRice_pSTY_pform$dataset, graph = FALSE)

PXD000923A_pform_01 <- PXD000923A_pform[1:max(which(PXD000923A_pform$FLR_Adj_Score<=0.01)),]
PXD002222A_pform_01 <- PXD002222A_pform[1:max(which(PXD002222A_pform$FLR_Adj_Score<=0.01)),]
PXD002756A_pform_01 <- PXD002756A_pform[1:max(which(PXD002756A_pform$FLR_Adj_Score<=0.01)),]
PXD004705A_pform_01 <- PXD004705A_pform[1:max(which(PXD004705A_pform$FLR_Adj_Score<=0.01)),]
PXD004939A_pform_01 <- PXD004939A_pform[1:max(which(PXD004939A_pform$FLR_Adj_Score<=0.01)),]
PXD005241A_pform_01 <- PXD005241A_pform[1:max(which(PXD005241A_pform$FLR_Adj_Score<=0.01)),]
PXD012764A_pform_01 <- PXD012764A_pform[1:max(which(PXD012764A_pform$FLR_Adj_Score<=0.01)),]
PXD019291A_pform_01 <- PXD019291A_pform[1:max(which(PXD019291A_pform$FLR_Adj_Score<=0.01)),]

PXD000923A_pform_02.5 <- PXD000923A_pform[1:max(which(PXD000923A_pform$FLR_Adj_Score<=0.025)),]
PXD002222A_pform_02.5 <- PXD002222A_pform[1:max(which(PXD002222A_pform$FLR_Adj_Score<=0.025)),]
PXD002756A_pform_02.5 <- PXD002756A_pform[1:max(which(PXD002756A_pform$FLR_Adj_Score<=0.025)),]
PXD004705A_pform_02.5 <- PXD004705A_pform[1:max(which(PXD004705A_pform$FLR_Adj_Score<=0.025)),]
PXD004939A_pform_02.5 <- PXD004939A_pform[1:max(which(PXD004939A_pform$FLR_Adj_Score<=0.025)),]
PXD005241A_pform_02.5 <- PXD005241A_pform[1:max(which(PXD005241A_pform$FLR_Adj_Score<=0.025)),]
PXD012764A_pform_02.5 <- PXD012764A_pform[1:max(which(PXD012764A_pform$FLR_Adj_Score<=0.025)),]
PXD019291A_pform_02.5 <- PXD019291A_pform[1:max(which(PXD019291A_pform$FLR_Adj_Score<=0.025)),]

PXD000923A_pform_05 <- PXD000923A_pform[1:max(which(PXD000923A_pform$FLR_Adj_Score<=0.05)),]
PXD002222A_pform_05 <- PXD002222A_pform[1:max(which(PXD002222A_pform$FLR_Adj_Score<=0.05)),]
PXD002756A_pform_05 <- PXD002756A_pform[1:max(which(PXD002756A_pform$FLR_Adj_Score<=0.05)),]
PXD004705A_pform_05 <- PXD004705A_pform[1:max(which(PXD004705A_pform$FLR_Adj_Score<=0.05)),]
PXD004939A_pform_05 <- PXD004939A_pform[1:max(which(PXD004939A_pform$FLR_Adj_Score<=0.05)),]
PXD005241A_pform_05 <- PXD005241A_pform[1:max(which(PXD005241A_pform$FLR_Adj_Score<=0.05)),]
PXD012764A_pform_05 <- PXD012764A_pform[1:max(which(PXD012764A_pform$FLR_Adj_Score<=0.05)),]
PXD019291A_pform_05 <- PXD019291A_pform[1:max(which(PXD019291A_pform$FLR_Adj_Score<=0.05)),]


AllRice_pASTY_pform_01<-dplyr::bind_rows(PXD000923A_pform_01, PXD002222A_pform_01, PXD002756A_pform_01, PXD004705A_pform_01,PXD004939A_pform_01, 
                                       PXD005241A_pform_01, PXD012764A_pform_01, PXD019291A_pform_01)

AllRice_pASTY_pform_02.5<-dplyr::bind_rows(PXD000923A_pform_02.5, PXD002222A_pform_02.5, PXD002756A_pform_02.5, PXD004705A_pform_02.5,PXD004939A_pform_02.5,
                                        PXD005241A_pform_02.5, PXD012764A_pform_02.5, PXD019291A_pform_02.5)

AllRice_pASTY_pform_05<-dplyr::bind_rows(PXD000923A_pform_05, PXD002222A_pform_05, PXD002756A_pform_05, PXD004705A_pform_05,PXD004939A_pform_05, 
                                       PXD005241A_pform_05, PXD012764A_pform_05, PXD019291A_pform_05)

AllRice_pASTY_pform_01_Excluding_A <- AllRice_pASTY_pform_01[AllRice_pASTY_pform_01$Amino!="A",]

tab1(AllRice_pASTY_pform_01_Excluding_A$dataset, graph = FALSE)

AllRice_pASTY_pform_02.5_Excluding_A <- AllRice_pASTY_pform_02.5[AllRice_pASTY_pform_02.5$Amino!="A",]

tab1(AllRice_pASTY_pform_02.5_Excluding_A$dataset, graph = FALSE)

AllRice_pASTY_pform_05_Excluding_A <- AllRice_pASTY_pform_05[AllRice_pASTY_pform_05$Amino!="A",]

tab1(AllRice_pASTY_pform_05_Excluding_A$dataset, graph = FALSE)


PXD000923_pform_95 <- PXD000923_pform[PXD000923_pform$PTM_Final_prob>=0.95,]
PXD002222_pform_95 <- PXD002222_pform[PXD002222_pform$PTM_Final_prob>=0.95,]
PXD002756_pform_95 <- PXD002756_pform[PXD002756_pform$PTM_Final_prob>=0.95,]
PXD004705_pform_95 <- PXD004705_pform[PXD004705_pform$PTM_Final_prob>=0.95,]
PXD004939_pform_95 <- PXD004939_pform[PXD004939_pform$PTM_Final_prob>=0.95,]
PXD005241_pform_95 <- PXD005241_pform[PXD005241_pform$PTM_Final_prob>=0.95,]
PXD012764_pform_95 <- PXD012764_pform[PXD012764_pform$PTM_Final_prob>=0.95,]
PXD019291_pform_95 <- PXD019291_pform[PXD019291_pform$PTM_Final_prob>=0.95,]

PXD000923_pform_97.5 <- PXD000923_pform[PXD000923_pform$PTM_Final_prob>=0.975,]
PXD002222_pform_97.5 <- PXD002222_pform[PXD002222_pform$PTM_Final_prob>=0.975,]
PXD002756_pform_97.5 <- PXD002756_pform[PXD002756_pform$PTM_Final_prob>=0.975,]
PXD004705_pform_97.5 <- PXD004705_pform[PXD004705_pform$PTM_Final_prob>=0.975,]
PXD004939_pform_97.5 <- PXD004939_pform[PXD004939_pform$PTM_Final_prob>=0.975,]
PXD005241_pform_97.5 <- PXD005241_pform[PXD005241_pform$PTM_Final_prob>=0.975,]
PXD012764_pform_97.5 <- PXD012764_pform[PXD012764_pform$PTM_Final_prob>=0.975,]
PXD019291_pform_97.5 <- PXD019291_pform[PXD019291_pform$PTM_Final_prob>=0.975,]

PXD000923_pform_99 <- PXD000923_pform[PXD000923_pform$PTM_Final_prob>=0.99,]
PXD002222_pform_99 <- PXD002222_pform[PXD002222_pform$PTM_Final_prob>=0.99,]
PXD002756_pform_99 <- PXD002756_pform[PXD002756_pform$PTM_Final_prob>=0.99,]
PXD004705_pform_99 <- PXD004705_pform[PXD004705_pform$PTM_Final_prob>=0.99,]
PXD004939_pform_99 <- PXD004939_pform[PXD004939_pform$PTM_Final_prob>=0.99,]
PXD005241_pform_99 <- PXD005241_pform[PXD005241_pform$PTM_Final_prob>=0.99,]
PXD012764_pform_99 <- PXD012764_pform[PXD012764_pform$PTM_Final_prob>=0.99,]
PXD019291_pform_99 <- PXD019291_pform[PXD019291_pform$PTM_Final_prob>=0.99,]


AllRice_pSTY_pform_95<-dplyr::bind_rows(PXD000923_pform_95, PXD002222_pform_95, PXD002756_pform_95,PXD004705_pform_95,PXD004939_pform_95, 
                                      PXD005241_pform_95, PXD012764_pform_95, PXD019291_pform_95)

AllRice_pSTY_pform_97.5<-dplyr::bind_rows(PXD000923_pform_97.5, PXD002222_pform_97.5, PXD002756_pform_97.5,  PXD004705_pform_97.5,PXD004939_pform_97.5, 
                                        PXD005241_pform_97.5, PXD012764_pform_97.5,PXD019291_pform_97.5)

AllRice_pSTY_pform_99<-dplyr::bind_rows(PXD000923_pform_99, PXD002222_pform_99, PXD002756_pform_99,  PXD004705_pform_99, PXD004939_pform_99, 
                                      PXD005241_pform_99, PXD012764_pform_99, PXD019291_pform_99)



tab1(AllRice_pSTY_pform_95$dataset, graph = FALSE)

tab1(AllRice_pSTY_pform_97.5$dataset, graph = FALSE)

tab1(AllRice_pSTY_pform_99$dataset, graph = FALSE)


